using UnityEngine;
using System.Collections;

public class s_Story : MonoBehaviour
{
	public GameObject[] storyPages;
	public Camera forgroundCamera;
	
	int currentPage = 0;
	float pageDepth = 0.0005f;
	int uiElementHideOffset = 100;
	
	void Start()
	{
		GameObject.Find("UI Elements").transform.position += Vector3.right*uiElementHideOffset;
		StartCoroutine(CreatePages());
	}
			
	IEnumerator CreatePages()
	{
		yield return new WaitForFixedUpdate();
		
		transform.position += Vector3.forward*10;
		transform.position += Vector3.left*10;
		
		//transform.position = Vector3.zero;
		
		float currentDepth = pageDepth;
		
		for (int i = storyPages.Length-1; i >= 0; --i)
		{
			storyPages[i].transform.parent.transform.position = new Vector3(storyPages[i].transform.position.x
																			,currentDepth
																			,storyPages[i].transform.position.z);
			
			//storyPages[i].transform.position = Vector3.zero;
			currentDepth += pageDepth;
		}
	}
	
	void Update()
	{
		//Gets input: click for osx, windows, and editor. Touch for android and iphone
#if UNITY_EDITOR || UNITY_STANDALONE_WIN || UNITY_STANDALONE_OSX || UNITY_WEBPLAYER
		if (Input.GetMouseButtonDown(0))
#endif
					
#if UNITY_ANDROID && !UNITY_EDITOR || UNITY_IPHONE && !UNITY_EDITOR
		for (int i = 0; i < Input.touchCount; ++i)
            if (Input.GetTouch(i).phase.Equals(TouchPhase.Began))
#endif
						
		{
				
			//Then makes a ray, for touch or click position
#if UNITY_ANDROID && !UNITY_EDITOR || UNITY_IPHONE && !UNITY_EDITOR
 			Ray ray = forgroundCamera.ScreenPointToRay(Input.GetTouch(i).position);
#endif
				
#if UNITY_EDITOR || UNITY_STANDALONE_WIN || UNITY_STANDALONE_OSX || UNITY_WEBPLAYER
			Ray ray = forgroundCamera.ScreenPointToRay(Input.mousePosition);
#endif
			
			RaycastHit hit;
				
			//If you click on something
	  		if (Physics.Raycast(ray, out hit, 200.0f))
			{
				if (hit.collider.gameObject.name == "ButtonStoryNext")
				{
					s_Buttons button = hit.collider.gameObject.GetComponent<s_Buttons>();
					button.Clicked();
					
					storyPages[currentPage].transform.parent.transform.position = storyPages[currentPage].transform.position;
					storyPages[currentPage].animation.Play();
						
					++currentPage;
						
					if (currentPage == storyPages.Length)
					{
						transform.position = Vector3.left * 1000;
						GameObject.Find("UI Elements").transform.position += Vector3.left*uiElementHideOffset;
					}
						
				}
			}
		}
	}
}
